/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ClientScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.network.PacketGetScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ScreenRenderer
implements BlockEntityRenderer<ScreenTileEntity> {
    private static final ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public ScreenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull ScreenTileEntity tileEntity, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        ScreenRenderer.renderInternal(tileEntity, matrixStack, buffer, packedLightIn, packedOverlayIn);
    }

    public static void renderInternal(ScreenTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn, int packedOverlayIn) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        Direction facing = Direction.SOUTH;
        Direction horizontalFacing = Direction.SOUTH;
        if (!tileEntity.isDummy()) {
            BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(tileEntity.m_58899_());
            if (state.m_60734_() instanceof ScreenBlock) {
                facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                horizontalFacing = (Direction)state.m_61143_((Property)ScreenBlock.HORIZ_FACING);
            } else {
                return;
            }
        }
        matrixStack.m_85836_();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yRotation));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(xRotation));
        matrixStack.m_85837_(0.0, 0.0, -0.4375);
        if (tileEntity.isDummy()) {
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)false);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)98, (int)28, (int)252, (int)182, (int)-2236963);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)100, (int)30, (int)250, (int)180, (int)-13421773);
        } else if (!tileEntity.isTransparent()) {
            ScreenRenderer.renderScreenBoard(matrixStack, buffer, tileEntity.getSize(), tileEntity.getColor(), packedLightIn, packedOverlayIn);
        }
        if (tileEntity.isRenderable()) {
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            Map<Integer, IModuleData> screenData = ScreenRenderer.updateScreenData(tileEntity);
            List<IClientScreenModule<?>> modules = tileEntity.getClientScreenModules();
            if (tileEntity.isShowHelp()) {
                modules = ScreenTileEntity.getHelpingScreenModules();
            }
            ScreenRenderer.renderModules(matrixStack, buffer, fontrenderer, tileEntity, modules, screenData, tileEntity.isDummy() ? 0 : tileEntity.getSize());
        }
        matrixStack.m_85849_();
    }

    private static Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalPos key;
        Map<Integer, Object> screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > (long)((Integer)ScreenConfiguration.SCREEN_REFRESH_TIMING.get()).intValue() && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalPos pos = GlobalPos.m_122643_(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.m_58899_());
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetScreenData("rftoolsutility", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = GlobalPos.m_122643_(screenTileEntity.getDimension(), (BlockPos)screenTileEntity.m_58899_()))) == null) {
            screenData = Collections.emptyMap();
        }
        return screenData;
    }

    private static void renderModules(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, ScreenTileEntity tileEntity, List<IClientScreenModule<?>> modules, Map<Integer, IModuleData> screenData, int size) {
        PoseStack stack;
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        float f = 0.0075f;
        float minf3 = -1.0f;
        if (tileEntity.isDummy()) {
            stack = new PoseStack();
            stack.m_85837_(100.0, 30.0, 0.0);
            f = 1.0f;
            minf3 = 1.0f;
        } else {
            stack = matrixStack;
        }
        BlockPos pos = tileEntity.m_58899_();
        HitResult mouseOver = Minecraft.m_91087_().f_91077_;
        IClientScreenModule<?> hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        if (!tileEntity.isDummy()) {
            Direction horizontalFacing;
            double zz;
            double yy;
            double xx;
            Direction sideHit;
            BlockState blockState = tileEntity.m_58904_().m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get() && block != ScreenModule.SCREEN_HIT.get()) {
                return;
            }
            if (mouseOver instanceof BlockHitResult && (sideHit = ((BlockHitResult)mouseOver).m_82434_()) == blockState.m_61143_((Property)BlockStateProperties.f_61372_) && (hit = tileEntity.getHitModule(xx = mouseOver.m_82450_().f_82479_ - (double)pos.m_123341_(), yy = mouseOver.m_82450_().f_82480_ - (double)pos.m_123342_(), zz = mouseOver.m_82450_().f_82481_ - (double)pos.m_123343_(), sideHit, horizontalFacing = (Direction)blockState.m_61143_((Property)ScreenBlock.HORIZ_FACING), tileEntity.isDummy() ? 1 : tileEntity.getSize())) != null) {
                hitModule = modules.get(hit.moduleIndex());
            }
        }
        for (IClientScreenModule<?> module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                stack.m_85836_();
                switch (module.getTransformMode()) {
                    case TEXT: {
                        stack.m_85837_(-0.5, 0.5, (double)0.03f);
                        stack.m_85841_(f * factor, minf3 * f * factor, f);
                        break;
                    }
                    case TEXTLARGE: {
                        stack.m_85837_(-0.5, 0.5, (double)0.03f);
                        stack.m_85841_(f * 2.0f * factor, minf3 * f * 2.0f * factor, f * 2.0f);
                        break;
                    }
                    case ITEM: {
                        stack.m_85837_(0.0, 0.0, (double)-0.04f);
                        if (!tileEntity.isDummy()) break;
                        stack.m_85837_(65.0, 70.0, 0.0);
                        stack.m_85841_(133.33334f, -133.33334f, 10000.0f);
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.x();
                        hity = hit.y() - hit.currenty();
                    }
                    boolean truetype = false;
                    switch (tileEntity.getTrueTypeMode()) {
                        case -1: {
                            break;
                        }
                        case 1: {
                            truetype = (Boolean)ScreenConfiguration.forceNoTruetype.get() == false;
                            break;
                        }
                        case 0: {
                            if (((Boolean)ScreenConfiguration.forceNoTruetype.get()).booleanValue()) break;
                            truetype = (Boolean)ScreenConfiguration.useTruetype.get();
                        }
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity, truetype, tileEntity.isBright() || tileEntity.isDummy(), ScreenConfiguration.getTrueTypeFont());
                    module.render(stack, buffer, (IModuleRenderHelper)clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
                stack.m_85849_();
            }
            ++moduleIndex;
        }
    }

    private static void renderScreenBoard(PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int size, int color, int packedLightIn, int packedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.QUADS_NOTEXTURE);
        float s = size;
        float dim = switch (size) {
            case 2 -> 2.46f;
            case 1 -> 1.46f;
            default -> 0.46f;
        };
        float fr = 0.5f;
        float fg = 0.5f;
        float fb = 0.5f;
        float zback = 0.05f;
        float zfront = 0.0f;
        float ss = 0.5f;
        builder.m_85982_(matrix, -ss, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zfront).m_85950_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zfront).m_85950_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zfront).m_85950_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, -ss, zfront).m_85950_(fr * 0.8f, fg * 0.8f, fb * 0.8f, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, -ss, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, -ss, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -ss, ss + s, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, ss + s, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zback).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, ss + s, -ss, zfront).m_85950_(fr, fg, fb, 1.0f).m_85969_(packedLightIn).m_5752_();
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.m_85982_(matrix, -0.46f, dim, -0.01f).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, dim, dim, -0.01f).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, dim, -0.46f, -0.01f).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        builder.m_85982_(matrix, -0.46f, -0.46f, -0.01f).m_85950_(r, g, b, 1.0f).m_85969_(packedLightIn).m_5752_();
        matrixStack.m_85849_();
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ScreenModule.TYPE_SCREEN.get()), ScreenRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ScreenModule.TYPE_CREATIVE_SCREEN.get()), ScreenRenderer::new);
    }
}

